/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.fmtmedia;

import com.ibm.hwmca.base.fmtmedia.FormatMediaConstants;
import com.ibm.hwmca.base.fmtmedia.FormatMediaErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.UserTaskManager;

public class MediaFormatBean
extends PanelBean
implements DataBean,
TaskActionListener,
FormatMediaErrorIds,
FormatMediaConstants {
    private static final String TRACE_MASKT = "XFMTCMBT";
    private static final String TRACE_MASKF = "XFMTCMBF";
    private static final String TRACE_MASKD = "XFMTCMBD";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(3, "MediaFormatApp");
    private String[] m_sMediaFormatChoiceSelection;
    private boolean dvdAvail;
    private boolean disketteAvail;
    private boolean memstickAvail;

    public MediaFormatBean(boolean dvd, boolean disk, boolean memstick) {
        Trace.trace(TRACE_MASKT, "-> MediaFormatBean.constructor() = " + this);
        this.dvdAvail = dvd;
        this.disketteAvail = disk;
        this.memstickAvail = memstick;
        Trace.trace(TRACE_MASKT, "<- MediaFormatBean.constructor()");
    }

    public String[] getMediaFormatChoiceSelection() {
        Trace.trace(TRACE_MASKF, "<> MediaFormatBean.getMediaFormatChoiceList()");
        return this.m_sMediaFormatChoiceSelection;
    }

    public void setMediaFormatChoiceSelection(String[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "<> MediaFormatBean.setFormatChoiceList()");
        this.m_sMediaFormatChoiceSelection = selected;
    }

    public Capabilities getCapabilities() {
        Trace.trace(TRACE_MASKF, "<> MediaFormatBean.getCapabilities()");
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "<> MediatFormatBean.verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKF, "<> MediatFormatBean.save()");
    }

    public void load() {
        Trace.trace(TRACE_MASKF, "-> MediaFormatBean.load()");
        Trace.trace(TRACE_MASKF, "dvd available = " + this.dvdAvail);
        Trace.trace(TRACE_MASKF, "diskette available = " + this.disketteAvail);
        Trace.trace(TRACE_MASKF, "memory stick available = " + this.memstickAvail);
        Trace.trace(TRACE_MASKF, "<- MediaFormatBean.load()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> MediaFormatBean.prepare()");
        if (!this.dvdAvail) {
            Trace.trace(TRACE_MASKT, "DVD is not installed set not shown for dvd option.");
            this.userTaskManager.setShown("DvdItem", false);
        }
        if (!this.disketteAvail) {
            Trace.trace(TRACE_MASKT, "Diskette is not installed set not shown for diskette option.");
            this.userTaskManager.setShown("DisketteItem", false);
        }
        if (!this.memstickAvail) {
            Trace.trace(TRACE_MASKT, "Flash memory stick is not installed set not shown.");
            this.userTaskManager.setShown("MemoryKeyItem", false);
        }
        if (this.dvdAvail) {
            this.m_sMediaFormatChoiceSelection = new String[1];
            this.m_sMediaFormatChoiceSelection[0] = "DvdItem";
        } else if (this.disketteAvail) {
            this.m_sMediaFormatChoiceSelection = new String[1];
            this.m_sMediaFormatChoiceSelection[0] = "DisketteItem";
        } else if (this.memstickAvail) {
            this.m_sMediaFormatChoiceSelection = new String[1];
            this.m_sMediaFormatChoiceSelection[0] = "MemoryKeyItem";
        } else {
            Trace.trace(TRACE_MASKT, "No selection available disable format button");
            this.userTaskManager.setEnabled("OkButton", false);
        }
        Trace.trace(TRACE_MASKT, "<- MediaFormatBean.prepare()");
    }

    protected void finalize() throws Throwable {
        Trace.trace(TRACE_MASKF, "--bean--in MediaFormatBean finalize of " + this);
        super.finalize();
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> MediaFormatBean.panelAction(TaskActionEvent) for" + this);
        PanelTaskletRequest request = new PanelTaskletRequest();
        String cmd = event.getActionCommand();
        Trace.trace(TRACE_MASKF, "Command is " + cmd + ".");
        if (cmd.equals("CANCEL") || cmd.equals("CancelButton")) {
            Trace.trace(TRACE_MASKT, "disposing");
            this.dispose();
        } else if (cmd.equals("OkButton")) {
            Trace.trace(TRACE_MASKF, "OK Button depressed");
            UserTaskManager utm = (UserTaskManager)event.getSource();
            utm.storeAllElements();
            utm.storeElement("MediaFormatChoice");
            String[] Radio_button = this.getMediaFormatChoiceSelection();
            Trace.trace(TRACE_MASKF, "Radio button = " + Radio_button[0]);
            if (Radio_button[0].equals("DisketteItem")) {
                request.setData("radiobutton", "DisketteItem");
            } else if (Radio_button[0].equals("MemoryKeyItem")) {
                request.setData("radiobutton", "MemoryKeyItem");
            } else {
                request.setData("radiobutton", "DvdItem");
            }
            request.setData("event", "OkButton");
            Trace.trace(TRACE_MASKT, "Right before post");
            this.postTaskletRequest(request);
        } else {
            Trace.trace(TRACE_MASKT, "I don't know this button: " + cmd + ".");
        }
        Trace.trace(TRACE_MASKT, "<- MediaFormatBean.panelAction(TaskActionEvent).");
    }
}

